#ifndef _DLL_
#ifndef EXDRV_MAJOR
#define EXDRV_MAJOR 0

#ifndef EXDRV_MINOR
#define EXDRV_MINOR 0

#endif
#endif
#endif

#ifndef EX_MAXDEV
#define EX_MAXDEV 16
#endif


#define	RESOLUTION							50
//***********************************************************//
#define	LATTICE_AD00_DATA						0X40
#define	LATTICE_AD00_CONFIG						0X80
#define	LATTICE_AD_STATUS						0xB0
#define	LATTICE_AD_DATA_OFFSET					0X02
#define	LATTICE_AD_CONFIG_OFFSET					0X02
#define	LATTICE_AD_PORT_OFFSET					0X10
//*********************Lattice mode***********************//

#define	LATTICE_INPUT					0X0000
#define	LATTICE_OUTPUT				0X0001

#define	LATTICE_TIMER_OFFSET			0X0020

#define	LATTICE_TC_TIMER_MODE			0X0000
#define	LATTICE_TC_COUNTER_MODE			0X0001
#define	LATTICE_TC_SW_DEC_MODE			0X0003
#define	LATTICE_TC_PWM_MODE			0X0004
#define	LATTICE_TC_QUADRATURE_MODE		0X0008

#define	LATTICE_NO_GATE				0x0000
#define	LATTICE_GATED				0x0001
#define	LATTICE_EDGE_START				0x0002

#define	LATTICE_GATE_MODE				0
#define	LATTICE_TI_MODE				1

#define	LATTICE_NO_TOUT				0x0000
#define	LATTICE_OUT_PULSE				0x0001
#define	LATTICE_OUT_LEVEL				0x0002
#define	LATTICE_OUT_TOGGLE				0x0004
//---------------------mode is bit2 bit3 so <<2------------
#define	LATTICE_5V_5V					0x0	//0x0000<<2
#define	LATTICE_10V_10V				0x4	//0x0001<<2
#define	LATTICE_0V_5V					0x8	//0x0002<<2
#define	LATTICE_0V_10V				0xc	//0x0003<<2
//---------------------channel is bit4 bit5 bit6 so <<4------------
#define	LATTICE_CHANNEL_0				0x00	//000<<4
#define	LATTICE_CHANNEL_1				0x40	//100<<4
#define	LATTICE_CHANNEL_2				0x10	//001<<4
#define	LATTICE_CHANNEL_3				0x50	//101<<4
#define	LATTICE_CHANNEL_4				0x20	//010<<4
#define	LATTICE_CHANNEL_5				0x60	//110<<4
#define	LATTICE_CHANNEL_6				0x30	//011<<4
#define	LATTICE_CHANNEL_7				0x70	//111<<4
//***********************************************************//
//old
/*
#define		_IRQ_STATUS				0x000C	//register of Interrupt request enable status
#define		_IRQ_MASK				0x0008	//Interrupt request mask register
#define 	_TC_IRQ_STATUS			0x0062	//register of T/C interrupt request enable status
#define 	_TC_IRQ_MASK 				0x0060	//T/C interrupt request enable register
#define 	_TC_IRQ_STATUS			0x0062	//register of T/C interrupt request enable status*/
//**********************************************
// reg map
//**********************************************
#define	LATTICE_CARD_ID				0x0078	//card ID register
#define	LATTICE_I2C_OUT_B				0x007a	//security register

#define	LATTICE_TTL_PORT0				0x00
#define	LATTICE_TTL_PORT1				0x02
#define	LATTICE_TTL_PORT0_DIR			0x04
#define	LATTICE_TTL_PORT1_DIR			0x06

#define	LATTICE_TTL_DEBOUNCE0			0x10
#define	LATTICE_TTL_DEBOUNCE1			0x12

#define	LATTICE_TTL_IRQ_POLARITY			0x24
#define	LATTICE_TTL_IRQ_MASK			0x26
#define	LATTICE_TTL_IRQ_STATUS			0x28


#define	LATTICE_TC0_CONTROL				0x00
#define	LATTICE_TC0_MODE				0x02
#define	LATTICE_TIGATE0_MODE			0x04
#define	LATTICE_TO0_MODE				0x06
#define	LATTICE_RETRIGGER0_MODE			0x08
#define	LATTICE_TC0_PRELOAD_L			0x0A
#define	LATTICE_TC0_PRELOAD_H			0x0C
#define	LATTICE_TC0_COUNTER_L			0x0E
#define	LATTICE_TC0_COUNTER_H			0x10
#define	LATTICE_TC0_OUT_WIDTH			0x12
#define	LATTICE_TI0_MULTIPLE_RATE			0x14
#define	LATTICE_TC0_IRQ_MASK			0x16
#define	LATTICE_TC0_IRQ_STATUS			0x18

#define	LATTICE_TC1_CONTROL				0x20
#define	LATTICE_TC1_MODE				0x22
#define	LATTICE_TIGATE1_MODE			0x24
#define	LATTICE_TO1_MODE				0x26
#define	LATTICE_RETRIGGER1_MODE			0x28
#define	LATTICE_TC1_PRELOAD_L			0x2A
#define	LATTICE_TC1_PRELOAD_H			0x2C
#define	LATTICE_TC1_COUNTER_L			0x2E
#define	LATTICE_TC1_COUNTER_H			0x30
#define	LATTICE_TC1_OUT_WIDTH			0x32
#define	LATTICE_TI1_MULTIPLE_RATE			0x34
#define	LATTICE_TC1_IRQ_MASK			0x36
#define	LATTICE_TC1_IRQ_STATUS			0x38
//***********************************************************//
#define	LATTICE_AD00_DATA				0X40
#define	LATTICE_AD00_CONFIG				0X80
#define	LATTICE_AD_STATUS				0xB0
#define	LATTICE_AD_DATA_OFFSET			0X02
#define	LATTICE_AD_CONFIG_OFFSET			0X02
#define	LATTICE_AD_PORT_OFFSET			0X10
//**********************************************
#define	LATTICE_PCI_IRQ_ENABLE			0x0076
//**********************************************
//***********************************************************//
////////////// Error Code ///////////////////////
#define 	NO_CARD				0xff
#define 	SUCCESS				0
#define 	INVALID_ADDRESS			-1
#define		NOPCIDEV				-2
#define		INVALID_CMD				-3
#define		INITIAL_FAIL				-100



//////////////////////////////////////
#define 	_EXIOC_NONE			0U
#define		_EXIOC_WRITE			1U
#define		_EXIOC_READ			2U

#define		_EXIOC(dir,type,nr,size) \
		(((dir)  << _IOC_DIRSHIFT) | \
	 	((type) << _IOC_TYPESHIFT) | \
	 	((nr)   << _IOC_NRSHIFT) | \
		((size) << _IOC_SIZESHIFT))

/* used to create numbers */
#define		_EXIO(type,nr)				_EXIOC(_EXIOC_NONE,(type),(nr),0)
#define		_EXIOR(type,nr,size)			_EXIOC(_EXIOC_READ,(type),(nr),sizeof(size))
#define		_EXIOW(type,nr,size)			_EXIOC(_EXIOC_WRITE,(type),(nr),sizeof(size))
#define		_EXIOWR(type,nr,size)			_EXIOC(_EXIOC_READ|_EXIOC_WRITE,(type),(nr),sizeof(size))


#define 	EXPCI_MAGIC			'j'
#define		EXPCI_RBYTE				_EXIOR(EXPCI_MAGIC, 11, 1) /* (TYPE,NR,SIZE) */
#define		EXPCI_WBYTE				_EXIOW(EXPCI_MAGIC, 12, 1)
#define		EXPCI_RWORD				_EXIOR(EXPCI_MAGIC, 13,1)
#define		EXPCI_WWORD				_EXIOW(EXPCI_MAGIC, 14,1)

#define		EXPCI_FIND				_EXIOR(EXPCI_MAGIC, 20, 1)
#define		EXPCI_RESOURCE				_EXIOR(EXPCI_MAGIC, 21, 1)

#define		EXPCI_HOOK_IRQ_SR			_EXIOW(EXPCI_MAGIC,41,1)
#define		EXPCI_UNHOOK_IRQ_SR			_EXIOW(EXPCI_MAGIC,42,1)
#define		EXPCI_IRQ_FLAG				_EXIOW(EXPCI_MAGIC,43,1)
#define		EXPCI_IRQ_CLEARFLAG			_EXIOW(EXPCI_MAGIC,44,1)
#define		EXPCI_IRQ_STATUS_READ		_EXIOW(EXPCI_MAGIC,45,1)

#define		EXPCI_WORK_QUEUE_ENABLE		_EXIOW(EXPCI_MAGIC,46,1)
#define		EXPCI_AD_DATA_READ			_EXIOW(EXPCI_MAGIC,47,1)


#ifndef _DLL_
static int EX94421A_init ( void );
static void EX94421A_exit ( void );
static int EX94421A_open ( struct inode* , struct file* );
static int EX94421A_release ( struct inode *, struct file * );
static int EX94421A_ioctl ( struct inode *, struct file*, unsigned int, unsigned long );
static int EX94421A_fasync ( int fd, struct file *, int mode );
static int find_EX94421A(void);

struct file_operations ex_fops=
  {
	.owner= THIS_MODULE,
	.read = NULL,
	.write = NULL,
	.ioctl= EX94421A_ioctl,
	.open= EX94421A_open,
	.release= EX94421A_release,
	.fasync = EX94421A_fasync,
  };

#endif
#define I386       //mark this means OS for 64bit

typedef struct _pci_info
  {
    unsigned short vendor_id;
    unsigned short device_id;
    unsigned short subvendor_id;
    unsigned short subdevice_id;
    unsigned short address_offset0;
    unsigned short address_offset1;
  } pci_info;

//-------------------------------------//

typedef union _io_data
  {
    unsigned char  b[4];//high byte is the msb
    unsigned short w[2];
#ifdef I386
    unsigned long l;
#else
    unsigned int  l;
#endif
  } io_data;

//-------------------------------------//

typedef  struct _card_resource
  {
	#ifdef I386
		unsigned long CardID;
		unsigned long base_address; //card resource io base address
		unsigned long tc_address; //card resource memory base address
	#else
		unsigned int CardID;
		unsigned int base_address; //card resource io base address
		unsigned int tc_address; //card resource memory base address
	#endif
	unsigned short address_offset;  //card resource address direct
	io_data	iodata;	

	unsigned short source;		//check card resource data is EX or TC
	unsigned short pci_enable;		//check card resource irq enable status
	unsigned short irq_flag;
	unsigned short irq_status;
	unsigned short irq_mask;
	unsigned short irq_tcstatus[2];
	unsigned short irq_tcmask[2];
	unsigned short thread_flag;
	unsigned short AD_Mode;
// 	long 		ad_data[24];
	long		ad_data[24];		//place where the ad data. 
	void (*callbackfn)(unsigned char); //callback function (unsigned char is CardID)

  } card_resource;



